#library packages
library(limma)
library(pROC)
library(ggplot2)
library(cutoff)
expFile="input.txt"      #gene expression matrix
setwd("E:\\metabolism\\LGG\\17.Model_gene\\2.singleROC") 

rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rt=as.data.frame(rt)
rt$SNAP91=as.numeric(rt$SNAP91)
rt$TAGLN2=as.numeric(rt$TAGLN2)
rt$GLMP=as.numeric(rt$GLMP)
rt$MCUB=as.numeric(rt$MCUB)

res=pROC::roc(rt$group, rt$SNAP91,aur=TRUE, ci=TRUE,smooth=TRUE)

p<- ggroc(res, color ="#237AB6",legacy.axes = TRUE)+
  geom_segment(aes(x = 0, xend = 1, y = 0, yend = 1), color="darkgrey", lineType=4)+
  theme_bw() + # 璁剧疆鑳屾櫙
  ggtitle("SNAP91 ROC Curve")+
  theme(plot.title = element_text(hjust = 0.5,size = 16),
        axis.text=element_text(size=12,colour = "black"),
        axis.title.x = element_text(size = 14),
        axis.title.y = element_text(size = 14))

p <- p+annotate("text",x=0.75,y=0.25,label=paste("AUC = ", round(res$auc,3)))+
  annotate("text",x=0.75,y=0.20,label=paste("95%CI: ", round(res$ci[1],3),'-',round(res$ci[3],3)))

#output plot
pdf(file="ROC.SNAP91.pdf", width=5, height=5)
print(p)
dev.off()


####################################################
res=pROC::roc(rt$group, rt$TAGLN2,aur=TRUE, ci=TRUE,smooth=TRUE)

p<- ggroc(res, color ="#237AB6",legacy.axes = TRUE)+
  geom_segment(aes(x = 0, xend = 1, y = 0, yend = 1), color="darkgrey", lineType=4)+
  theme_bw() + # 璁剧疆鑳屾櫙
  ggtitle("TAGLN2 ROC Curve")+
  theme(plot.title = element_text(hjust = 0.5,size = 16),
        axis.text=element_text(size=12,colour = "black"),
        axis.title.x = element_text(size = 14),
        axis.title.y = element_text(size = 14))

p <- p+annotate("text",x=0.75,y=0.25,label=paste("AUC = ", round(res$auc,3)))+
  annotate("text",x=0.75,y=0.20,label=paste("95%CI: ", round(res$ci[1],3),'-',round(res$ci[3],3)))

#output plot
pdf(file="ROC.TAGLN2.pdf", width=5, height=5)
print(p)
dev.off()

####################################################
res=pROC::roc(rt$group, rt$GLMP,aur=TRUE, ci=TRUE,smooth=TRUE)

p<- ggroc(res, color ="#237AB6",legacy.axes = TRUE)+
  geom_segment(aes(x = 0, xend = 1, y = 0, yend = 1), color="darkgrey", lineType=4)+
  theme_bw() + # 璁剧疆鑳屾櫙
  ggtitle("GLMP ROC Curve")+
  theme(plot.title = element_text(hjust = 0.5,size = 16),
        axis.text=element_text(size=12,colour = "black"),
        axis.title.x = element_text(size = 14),
        axis.title.y = element_text(size = 14))

p <- p+annotate("text",x=0.75,y=0.25,label=paste("AUC = ", round(res$auc,3)))+
  annotate("text",x=0.75,y=0.20,label=paste("95%CI: ", round(res$ci[1],3),'-',round(res$ci[3],3)))

#output plot
pdf(file="ROC.GLMP.pdf", width=5, height=5)
print(p)
dev.off()

####################################################
res=pROC::roc(rt$group, rt$MCUB,aur=TRUE, ci=TRUE,smooth=TRUE)

p<- ggroc(res, color ="#237AB6",legacy.axes = TRUE)+
  geom_segment(aes(x = 0, xend = 1, y = 0, yend = 1), color="darkgrey", lineType=4)+
  theme_bw() + # 璁剧疆鑳屾櫙
  ggtitle("MCUB ROC Curve")+
  theme(plot.title = element_text(hjust = 0.5,size = 16),
        axis.text=element_text(size=12,colour = "black"),
        axis.title.x = element_text(size = 14),
        axis.title.y = element_text(size = 14))

p <- p+annotate("text",x=0.75,y=0.25,label=paste("AUC = ", round(res$auc,3)))+
  annotate("text",x=0.75,y=0.20,label=paste("95%CI: ", round(res$ci[1],3),'-',round(res$ci[3],3)))

#output plot
pdf(file="ROC.MCUB.pdf", width=5, height=5)
print(p)
dev.off()

